import React from 'react';
import { useTheme } from '@/contexts/ThemeContext';

const LanguageSwitcher = () => {
  const { language, setLanguage } = useTheme();

  const languages = [
    { code: 'ar', label: 'AR', name: 'العربية' },
    { code: 'fr', label: 'FR', name: 'Français' },
    { code: 'en', label: 'EN', name: 'English' }
  ];

  return (
    <div className="flex items-center gap-1 bg-gray-200 dark:bg-gray-700 rounded-lg p-1">
      {languages.map((lang) => (
        <button
          key={lang.code}
          onClick={() => setLanguage(lang.code)}
          className={`
            px-3 py-1.5 rounded-md text-sm font-semibold transition-all duration-300
            ${language === lang.code
              ? 'bg-indigo-600 text-white shadow-md'
              : 'text-gray-700 dark:text-gray-300 hover:bg-gray-300 dark:hover:bg-gray-600'
            }
          `}
          title={lang.name}
        >
          {lang.label}
        </button>
      ))}
    </div>
  );
};

export default LanguageSwitcher;
