# 🚗 ERP Auto Algérie - Système de Gestion Intégré

> Plateforme SaaS complète pour importateurs, distributeurs de pièces automobiles et ateliers de réparation en Algérie

## 🌟 Aperçu Rapide

Application ERP moderne développée avec:
- **Backend:** FastAPI + MongoDB
- **Frontend:** React + Tailwind CSS + Shadcn/ui
- **Auth:** JWT avec gestion multi-rôles

---

## 🚀 Démarrage Rapide

### Accéder à l'Application

1. **Site Vitrine:** [http://localhost:3000](http://localhost:3000)
2. **Connexion Admin:** Cliquez sur "Connexion" ou allez sur [/login](http://localhost:3000/login)

### 🔑 Comptes de Test

**Administrateur:**
- Email: `admin@erpauto.dz`
- Mot de passe: `admin123`

**Client B2B:**
- Email: `client@garage.dz`
- Mot de passe: `client123`

---

## 📱 Fonctionnalités Principales

### ✅ Implémenté

- **Site Vitrine Public** - Page d'accueil moderne avec présentation des services
- **Authentification JWT** - Système de login sécurisé multi-rôles
- **Dashboard Admin** - KPIs en temps réel (produits, clients, commandes, CA)
- **Gestion Produits** - Liste, recherche, alertes stock, tarification multi-niveaux
- **Navigation Sidebar** - Menu latéral moderne et responsive

### 🚧 Structure Préparée (À Compléter)

- Gestion Commandes
- Gestion Clients
- Gestion Catégories & Marques
- Portail Client B2B
- Module Ateliers
- GED (Gestion Électronique de Documents)

---

## 🏗️ Architecture

```
/app/
├── backend/                 # API FastAPI
│   ├── server.py           # Routes & Endpoints
│   ├── models.py           # Modèles de données
│   ├── auth.py             # Authentication JWT
│   ├── dependencies.py     # Middlewares
│   └── seed_data.py        # Données de test
│
├── frontend/                # Application React
│   └── src/
│       ├── pages/          # Pages (public, auth, admin)
│       ├── components/     # Composants UI
│       ├── contexts/       # React Context (Auth)
│       ├── services/       # API Services
│       └── layouts/        # Layouts (AdminLayout)
│
└── DOCUMENTATION.md         # Documentation complète
```

---

## 📊 APIs Backend

**Base URL:** `http://localhost:8001/api`

### Authentification
- `POST /auth/login` - Connexion
- `POST /auth/register` - Inscription
- `GET /auth/me` - Utilisateur actuel

### Produits
- `GET /products` - Liste produits
- `POST /products` - Créer produit
- `PUT /products/{id}` - Modifier produit
- `DELETE /products/{id}` - Supprimer produit

### Commandes
- `GET /orders` - Liste commandes
- `POST /orders` - Créer commande
- `PATCH /orders/{id}/status` - Mettre à jour statut

### Dashboard
- `GET /dashboard/stats` - Statistiques

[Voir DOCUMENTATION.md pour la liste complète]

---

## 🎨 Technologies Utilisées

**Backend:**
- FastAPI 0.110.1
- Motor (MongoDB async driver)
- PyJWT & Passlib (Authentication)
- Pydantic (Validation)

**Frontend:**
- React 19
- React Router v7
- Tailwind CSS 3.4
- Shadcn/ui Components
- Axios
- i18next (Multilingue)
- Lucide React (Icons)

---

## 🔧 Gestion des Services

### Redémarrer les Services

```bash
# Tous les services
sudo supervisorctl restart all

# Backend uniquement
sudo supervisorctl restart backend

# Frontend uniquement
sudo supervisorctl restart frontend
```

### Voir les Logs

```bash
# Backend
tail -f /var/log/supervisor/backend.err.log

# Frontend
tail -f /var/log/supervisor/frontend.out.log
```

### Re-seed la Base de Données

```bash
cd /app/backend && python seed_data.py
```

---

## 📦 Données de Test Disponibles

- **4 Marques:** Bosch, Mann Filter, NGK, Valeo
- **5 Catégories:** Filtres, Freinage, Allumage, Éclairage, Moteur
- **5 Produits:** Avec stocks et tarifs multi-niveaux
- **2 Utilisateurs:** 1 Admin + 1 Client B2B
- **1 Profil Client:** Garage Mohamed SARL

---

## 🌍 Internationalisation

Support multilingue configuré:
- 🇫🇷 Français (par défaut)
- 🇩🇿 Arabe (partiellement traduit)
- 🇬🇧 Anglais (partiellement traduit)

---

## 📱 Navigation dans l'Application

### Interface Admin

1. **Connexion** avec `admin@erpauto.dz`
2. **Dashboard** - Vue d'ensemble des KPIs
3. **Produits** - Gestion complète du catalogue
4. **Menu Sidebar** - Navigation entre les modules

### Interface Client (Structure prête)

1. **Connexion** avec `client@garage.dz`
2. **Dashboard Client** - Statistiques personnalisées
3. **Catalogue** - Recherche et commande de produits

---

## 🎯 Prochaines Étapes de Développement

### Priorité Haute
1. Compléter la gestion des commandes
2. Développer le portail client B2B
3. Ajouter la gestion des clients

### Priorité Moyenne
4. Implémenter le module ateliers
5. Système de rapports et exports
6. Notifications en temps réel

### Priorité Basse
7. GED (Gestion documentaire)
8. Programme de fidélité
9. Multi-sites

---

## 💡 Notes de Développement

- **Hot Reload:** Backend et Frontend ont le hot-reload activé
- **Port Backend:** 8001 (ne pas changer)
- **Port Frontend:** 3000 (ne pas changer)
- **MongoDB:** mongodb://localhost:27017
- **JWT:** Tokens valides 24h

---

## 📞 Support & Contact

Pour toute question ou problème:
1. Consultez [DOCUMENTATION.md](./DOCUMENTATION.md) pour plus de détails
2. Vérifiez les logs avec les commandes ci-dessus
3. Contactez l'équipe de développement

---

## ✅ Statut du Projet

**Version:** 1.0.0 (MVP Phase 1)
**Statut:** ✅ Opérationnel et prêt pour les tests
**Date:** Janvier 2025

---

**🎉 Profitez de votre ERP Auto Algérie!**
